/* 
 
 ConsoleOutputViewController.m:
 
 Copyright (C) 2011 Thomas Hass
 
 This file is part of Csound iOS Examples.
 
 The Csound for iOS Library is free software; you can redistribute it
 and/or modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.   
 
 Csound is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with Csound; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA
 
 */

#import "ConsoleOutputViewController.h"

@implementation ConsoleOutputViewController

@synthesize currentMessage = mCurrentMessage;

- (IBAction)run:(UIButton *)sender
{
	mTextView.text = @"";
	
	[self.csound stopCsound];
	self.csound = [[CsoundObj alloc] init];
	[self.csound addCompletionListener:self];
	
	[self.csound setMessageCallback:@selector(messageCallback:) withListener:self];
	
	NSString *csdPath = nil;
	csdPath = [[NSBundle mainBundle] pathForResource:@"consoleoutput" ofType:@"csd"];
	[self.csound startCsound:csdPath];
}

- (void)updateUIWithNewMessage:(NSString *)newMessage
{
	NSString *oldText = mTextView.text;
	NSString *fullText = [oldText stringByAppendingString:newMessage];
	mTextView.text = fullText;
}

- (void)messageCallback:(NSValue *)infoObj
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	Message info;
	[infoObj getValue:&info];
	char message[1024];
	vsnprintf(message, 1024, info.format, info.valist);
	NSString *messageStr = [NSString stringWithFormat:@"%s", message];
	[self performSelectorOnMainThread:@selector(updateUIWithNewMessage:)
						   withObject:messageStr
						waitUntilDone:NO];
	[pool drain];
}

#pragma mark - CsoundObj Listener

- (void)csoundObjDidStart:(CsoundObj *)csoundObj {
}


- (void)csoundObjComplete:(CsoundObj *)csoundObj {
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        self.title = @"Console Output";
    }
    return self;
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
}

- (void)viewDidUnload
{
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

- (void)dealloc
{
	[mTextView release];
    [super dealloc];
}

@end
